#!/bin/bash

# Get the directory of the script
SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
echo $SCRIPT_DIR

sudo apt install cmake -y
sudo apt install libcurl4-openssl-dev -y

echo "Download the model conversion package....."
cd ~
rm -rf Utility_dont_remove
mkdir Utility_dont_remove
cd Utility_dont_remove
git clone https://github.com/ggml-org/llama.cpp
cd llama.cpp
git fetch origin 3b337b01a1a85c2f5b49376e8c0bbdb3f521528e #b07791aa1d4831a08ad54ca19aa206c0c5c0f34a
git checkout 3b337b01a1a85c2f5b49376e8c0bbdb3f521528e #b07791aa1d4831a08ad54ca19aa206c0c5c0f34a

echo "Build the model conversion package....."
cmake -B build
cmake --build build --config Release -j 4
cmake --build build --target llama-gguf-split

echo "Finish."
exit 0
