#!/bin/bash

sudo apt install -y ffmpeg # Validation (For image)
sudo apt install -y libopenblas-dev libomp-dev # ML MMSeg example

# 定義 Miniforge 安裝目錄
MINIFORGE_DIR="/opt/miniforge3"
MINIFORGE_FILE="Miniforge3-Linux-x86_64.sh"
LLaMA_Factory="LLaMA-Factory"

# Get the directory of the script
SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
echo $SCRIPT_DIR

export PATH="$MINIFORGE_DIR/bin:$PATH"
source $MINIFORGE_DIR/bin/activate
conda init

# 定義 Miniforge 環境名稱
MINIFORGE_ENV="lmmllava_amd"


# Conda environment
if conda env list | grep -q "$MINIFORGE_ENV"; then
  echo "環境 $MINIFORGE_ENV 已經存在"
  echo "刪除舊的環境 $MINIFORGE_ENV"
  conda remove -n $MINIFORGE_ENV --all -y
  echo "重新建立環境 $MINIFORGE_ENV..."
  conda create -n $MINIFORGE_ENV python=3.10 -y
  echo "環境 $MINIFORGE_ENV 建立完成"
else
  echo "環境 $MINIFORGE_ENV 不存在，正在建立..."
  conda create -n $MINIFORGE_ENV python=3.10 -y
  echo "環境 $MINIFORGE_ENV 建立完成"
fi

echo "eval '$($MINIFORGE_DIR/bin/conda shell.bash hook)'"
eval "$($MINIFORGE_DIR/bin/conda shell.bash hook)"
echo "conda activate $MINIFORGE_ENV"
conda activate $MINIFORGE_ENV


echo "pip install --upgrade pip "
pip install --upgrade pip  # enable PEP 660 support

echo "pip cache purge......"
pip cache purge

echo "pip install packages ......"
pip install diffusers==0.32.0
pip install transformers==4.55.0
pip install bitsandbytes==0.45.2
pip install accelerate==1.6.0
pip install imageio-ffmpeg==0.5.1
echo "Uninstall opencv-python packages......."
pip uninstall -y opencv-python
pip install opencv-python==4.10.0.84
pip install llama_index==0.12.19
pip install llama-index-core==0.12.19
pip install huggingface_hub==0.34.4
pip install langdetect==1.0.9
pip install docx2txt==0.8
pip install llama-index-llms-huggingface==0.4.2
pip install llama-index-embeddings-huggingface==0.5.1
pip install chromadb==0.6.3
pip install chroma-hnswlib==0.7.6
pip install llama-index-vector-stores-chroma==0.4.1
pip install soundfile==0.12.1
pip install librosa==0.10.2.post1
pip install ipython==8.28.0
pip install open-clip-torch==2.26.1

echo "ReInstall numpy...."
pip uninstall -y numpy
pip install numpy==1.26.4 --quiet

echo "Reinstall torch...."
#pip3 install torch==2.3.1 torchvision==0.18.1 torchaudio==2.3.1 --index-url https://download.pytorch.org/whl/rocm5.7
pip3 install torch==2.7.0+rocm6.3 torchvision==0.22.0+rocm6.3 torchaudio==2.7.0+rocm6.3  --index-url https://download.pytorch.org/whl/rocm6.3

echo "llama_cpp packages...."
pip install "sentencepiece>=0.1.98,<=0.2.0"
pip install protobuf==5.26.0
pip install "pytest>=5.2,<6.0"

echo "Install llama cpp python...."
export CC=/usr/bin/gcc
export CXX=/usr/bin/g++
export LD=/usr/bin/ld
export CMAKE_ARGS="-DGGML_HIP=on -DLLAMA_HIP=on -DAMDGPU_TARGETS=gfx1100,gfx1200,gfx1201"
# 檢查 /opt 目錄下是否存在 rocm 版本化目錄
ROCM_DIR=$(ls -d /opt/rocm-* 2>/dev/null | head -n 1)
if [ -n "$ROCM_DIR" ]; then
    ROCM_VERSION=$(basename "$ROCM_DIR" | sed 's/rocm-//')
    echo "檢測到的 ROCm 版本: $ROCM_VERSION"
else
    ROCM_DIR = "/opt/rocm-6.4.1"
fi
# 設置環境變數，使用檢測到的版本和路徑
export ROCM_PATH="$ROCM_DIR"
export PATH="$PATH:$ROCM_DIR/bin:$ROCM_DIR/hip/bin"
export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$ROCM_DIR/lib:$ROCM_DIR/hip/lib"
pip install llama-cpp-python==0.3.16 --no-cache --verbose

# Auto add the path of AMD driver
LINE="export PATH=\"$ROCM_DIR/bin:\$PATH\""
PROFILE_FILE="$HOME/.profile"
# Check if the line already exists
if grep -Fxq "$LINE" "$PROFILE_FILE"; then
    echo "Line already exists in $PROFILE_FILE"
else
    echo "Adding ROCm path to $PROFILE_FILE"
    echo "$LINE" >> "$PROFILE_FILE"
fi
# Source the updated profile
echo "Source to update profile : $PROFILE_FILE"
source "$PROFILE_FILE"

echo "ML packages................"
pip install nbformat==5.10.4
pip install unidecode==1.4.0
pip install rfc3987==1.3.8

echo "conda install -c conda-forge libstdcxx-ng=12"
conda install -c conda-forge libstdcxx-ng=12 -y

# Copy stage3.py to “~/.conda/envs/...
#echo "patching deepspeed"
#cp $SCRIPT_DIR/builder.py ~/.conda/envs/$MINIFORGE_ENV/lib/python3.10/site-packages/deepspeed/ops/op_builder
#cp -r $SCRIPT_DIR/partitioned_param_swapper.py ~/.conda/envs/$MINIFORGE_ENV/lib/python3.10/site-packages/deepspeed/runtime/swap_tensor
#cp $SCRIPT_DIR/stage3_amd.py ~/.conda/envs/$MINIFORGE_ENV/lib/python3.10/site-packages/deepspeed/runtime/zero/stage3.py

echo "Finish."
exit 0
